import { defineConfig } from 'vite'
import vue from '@vitejs/plugin-vue'
import vitePluginImport from 'vite-plugin-babel-import';
import path from 'path'
import legacy from '@vitejs/plugin-legacy'

const baseUrl = {
    development: './',
    // production: './'
    production: 'http://10.238.0.182:8090/' //新昌内网
        // production: 'http://psychologicalapi.myjxt.com/' //21公司的服务器
}

// https://vitejs.dev/config/
export default ({ mode }) => defineConfig({
    plugins: [
        vue(),
        vitePluginImport([{
            libraryName: 'element-plus',
            libraryDirectory: 'es',
            style(name) {
                return `element-plus/lib/theme-chalk/${name}.css`;
            },
        }]),
        legacy({
            targets: ['> 1%, last 1 version, ie >= 11'],
            additionalLegacyPolyfills: ['regenerator-runtime/runtime'], // 面向IE11时需要此插件
        }),
    ],
    base: baseUrl[mode],
    resolve: {
        alias: {
            '~': path.resolve(__dirname, './'),
            '@': path.resolve(__dirname, 'src')
        }
    },
    server: {
        proxy: {
            '/api': {
                target: 'http://10.238.0.182:8090', //新昌内网
                // target: 'http://psychologicalapi.myjxt.com/', //21公司的服务器
                changeOrigin: true,
                rewrite: path => path.replace(/^\/api/, '')
            }
        }
    }
})