import axios from 'axios'
import { ElMessage } from 'element-plus'
import router from '@/router/index'
import config from '~/config'


// 这边由于后端没有区分测试和正式，姑且都写成一个接口。
axios.defaults.baseURL = config[import.meta.env.MODE].baseUrl
// 携带 cookie，对目前的项目没有什么作用，因为我们是 token 鉴权
axios.defaults.withCredentials = true
// 请求头，headers 信息
axios.defaults.headers['X-Requested-With'] = 'XMLHttpRequest'
// 默认 post 请求，使用 application/json 形式
axios.defaults.headers.post['Content-Type'] = 'application/json'

// 请求拦截器，内部根据返回值，重新组装，统一管理。
axios.interceptors.response.use(res => {
  // 返回文件流不进行后续判断
  if (res.config?.responseType == 'blob') {
    return res.data
  }
  if (!res.data?.isSuccess) {
    if (res.data.errorMessage) ElMessage.error(res.data.errorMessage)
    return Promise.reject(res.data)
  }
  return res.data.result
})

export default axios